/*
 * Decompiled with CFR 0.152.
 */
package tiled.plugins.tmw;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import tiled.core.Map;
import tiled.core.MapLayer;
import tiled.core.Tile;
import tiled.core.TileLayer;

public class WLKWriter {
    private static final int FIRST_BYTE = 255;

    public static void writeMap(Map map, OutputStream outputStream) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MapLayer mapLayer = null;
        for (MapLayer mapLayer2 : map) {
            if (!mapLayer2.getName().equalsIgnoreCase("collision")) continue;
            mapLayer = mapLayer2;
        }
        if (mapLayer != null && mapLayer instanceof TileLayer) {
            int n = mapLayer.getWidth();
            int n2 = mapLayer.getHeight();
            outputStream.write(n & 0xFF);
            outputStream.write(n >> 8 & 0xFF);
            outputStream.write(n2 & 0xFF);
            outputStream.write(n2 >> 8 & 0xFF);
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    Tile tile = ((TileLayer)mapLayer).getTileAt(j, i);
                    if (tile != null && tile.getId() > 0) {
                        outputStream.write(1);
                        continue;
                    }
                    outputStream.write(0);
                }
            }
        } else {
            throw new Exception("No collision layer found!");
        }
        byteArrayOutputStream.writeTo(outputStream);
    }
}

